/* Before running this script install wrapper package -- racwrapper_setup.sql */

--Create aquser which will use the wrapper package

drop user aquser cascade ;

delete from wrapperuser.shrd$_type_table where schema = 'AQUSER';
delete from wrapperuser.shrd$_map_table where schema = 'AQUSER';

create user aquser identified by aquser;
grant connect, resource, unlimited tablespace to aquser;

grant execute on dbms_aq to aquser
/
grant execute on dbms_aqadm to aquser
/
grant execute on dbms_lock to aquser
/
grant create job to aquser
/

connect aquser/aquser
set serveroutput on
set echo on
spool racwrapper_test.log

-- Create private synonym for dbms_aqadm_wrapper package
create or replace synonym DBMS_AQADM FOR wrapperuser.DBMS_AQADM_WRAPPER;

-- Create type
create type message as object (
    id NUMBER,
    city VARCHAR2(30),
    priority NUMBER)
/


drop table prog1_processed_data
/
drop table prog2_processed_data
/
drop table prog3_processed_data
/

create table prog1_processed_data
(
    id NUMBER,
    city VARCHAR2(30),
    priority NUMBER
)
/

create table prog2_processed_data
(
    id NUMBER,
    city VARCHAR2(30),
    priority NUMBER
)
/

--Grant execute privilege to wrapperuser
grant execute on AQUSER.MESSAGE to wrapperuser;

--Create queue table
BEGIN
    dbms_output.put_line ('Creating Queue Table input_queue_table...');
    
    dbms_aqadm.CREATE_queue_table(
        queue_table => 'input_queue_table',
        multiple_consumers => TRUE,
        queue_payload_type => 'message',
        compatible => '8.1.3',
        comment => 'Creating input queue table');

END;
/

-- Create queue
BEGIN
    dbms_aqadm.CREATE_queue(
        queue_name => 'input_queue',
        queue_table => 'input_queue_table',
        comment => 'Demo Queue');
END;
/

-- Start the queue
exec dbms_aqadm.start_queue(queue_name => 'input_queue');

--Add subscribers
DECLARE
    subscriber sys.aq$_agent;
BEGIN
    subscriber := sys.aq$_agent('prog1', NULL, NULL);
    dbms_aqadm.add_subscriber(
        queue_name => 'input_queue',
        subscriber => subscriber);
END;
/

-- Schedule propagation
BEGIN
    dbms_aqadm.schedule_propagation(
      queue_name => 'input_queue',
      destination => 'db2',
      latency => '10');
END;
/


-- Create shards for the queue in remaining instances
exec dbms_aqadm.make_sharded_queue('input_queue_table');

-- Create private synonym for dbms_aq_wrapper package
create or replace synonym DBMS_AQ FOR wrapperuser.DBMS_AQ_WRAPPER;

connect aquser/aquser@inst1

@@racwrapper_enq.sql
select count(*),msg_state from aq$input_queue_table group by msg_state;

@@racwrapper_deq.sql
select count(*),msg_state from aq$input_queue_table group by msg_state;

connect aquser/aquser@inst2
-- The message will go to a shard in instance 2 
--instead of original queue table
@@racwrapper_enq.sql 
declare
phy_qt  varchar2(30);
cnt     number;
msg_state  varchar2(30);
begin
 phy_qt := wrapperuser.shrdinfo.get_PHYSICAL_QT('AQUSER','INPUT_QUEUE_TABLE');
 dbms_output.put_line('Physical qt is: '|| phy_qt);
 EXECUTE IMMEDIATE 'select count(*),msg_state from aq$' || phy_qt || 
                   ' group by msg_state' into cnt, msg_state;

 dbms_output.put_line(rpad('-',30,'-'));
 dbms_output.put_line(
                      rpad('NOOFMSG',12,' ') ||
                      rpad('MSG_STATE ',12,' '));
 dbms_output.put_line(rpad('-',30,'-'));
 dbms_output.put_line(
                      rpad(to_char(cnt),12,' ') ||
                      rpad(to_char(msg_state),12,' '));

END;
/


--Remove shards

 exec dbms_aqadm.remove_sharded_queue('input_queue_table');

-- Shards will not be deleted as they are not empty
 exec wrapperuser.shrdinfo.print;

-- Dequeue messages from queue table

connect aquser/aquser@inst2
set serveroutput on
@@racwrapper_deq.sql


-- All the messages are dequeued from the sharded queue
declare
phy_qt  varchar2(30);
cnt     number;
msg_state  varchar2(30);
begin
 phy_qt := wrapperuser.shrdinfo.get_PHYSICAL_QT('AQUSER','INPUT_QUEUE_TABLE');
 dbms_output.put_line('Physical qt is: '|| phy_qt);
 EXECUTE IMMEDIATE 'select count(*),msg_state from aq$' || phy_qt ||
                   ' group by msg_state' into cnt, msg_state;

 dbms_output.put_line(rpad('-',30,'-'));
 dbms_output.put_line(
                      rpad('NOOFMSG',12,' ') ||
                      rpad('MSG_STATE ',12,' '));
 dbms_output.put_line(rpad('-',30,'-'));
 dbms_output.put_line(
                      rpad(to_char(cnt),12,' ') ||
                      rpad(to_char(msg_state),12,' '));

END;
/

-- Wait for the job to remove all empty shards
exec dbms_lock.sleep(80);

-- Check map table. All the shards should have been deleted
exec wrapperuser.shrdinfo.print;  
